/*
 * Decompiled with CFR 0.152.
 */
package uws.service.actions;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.URL;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import uws.UWSException;
import uws.job.AbstractJob;
import uws.job.JobList;
import uws.job.serializer.UWSSerializer;
import uws.service.AbstractUWS;
import uws.service.UWSUrl;
import uws.service.actions.UWSAction;

public class ShowHomePage<JL extends JobList<J>, J extends AbstractJob>
extends UWSAction<JL, J> {
    private static final long serialVersionUID = 1L;

    public ShowHomePage(AbstractUWS<JL, J> u) {
        super(u);
    }

    @Override
    public String getName() {
        return "Show UWS Home Page";
    }

    @Override
    public String getDescription() {
        return "Shows the UWS home page. (URL: {baseUWS_URL}, Method: HTTP-GET, No parameter)";
    }

    @Override
    public boolean match(UWSUrl urlInterpreter, String userId, HttpServletRequest request) throws UWSException {
        return !urlInterpreter.hasJobList();
    }

    @Override
    public boolean apply(UWSUrl urlInterpreter, String userId, HttpServletRequest request, HttpServletResponse response) throws UWSException, IOException {
        if (this.uws.isDefaultHomePage()) {
            UWSSerializer serializer = this.uws.getSerializer(request.getHeader("Accept"));
            response.setContentType(serializer.getMimeType());
            this.uws.serialize((OutputStream)response.getOutputStream(), serializer);
        } else if (this.uws.isHomePageRedirection()) {
            this.uws.redirect(this.uws.getHomePage(), request, response);
        } else {
            URL homePageUrl = new URL(this.uws.getHomePage());
            BufferedReader reader = new BufferedReader(new InputStreamReader(homePageUrl.openStream()));
            response.setContentType("text/html");
            PrintWriter writer = response.getWriter();
            try {
                String line = null;
                while ((line = reader.readLine()) != null) {
                    writer.println(line);
                }
            }
            finally {
                writer.close();
                reader.close();
            }
        }
        return true;
    }
}

