/*
 * Decompiled with CFR 0.152.
 */
package uws.service.actions;

import java.io.IOException;
import java.io.OutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import uws.UWSException;
import uws.job.AbstractJob;
import uws.job.JobList;
import uws.job.serializer.UWSSerializer;
import uws.service.AbstractUWS;
import uws.service.UWSUrl;
import uws.service.actions.UWSAction;

public class GetJobParam<JL extends JobList<J>, J extends AbstractJob>
extends UWSAction<JL, J> {
    private static final long serialVersionUID = 1L;

    public GetJobParam(AbstractUWS<JL, J> u) {
        super(u);
    }

    @Override
    public String getName() {
        return "Get Job Parameter";
    }

    @Override
    public String getDescription() {
        return "Gets the value of a job attribute/parameter of the specified job. (URL: {baseUWS_URL}/{jobListName}/{job-id}/{job-attribute}, Method: HTTP-GET, No parameter)";
    }

    @Override
    public boolean match(UWSUrl urlInterpreter, String userId, HttpServletRequest request) throws UWSException {
        return urlInterpreter.hasJobList() && urlInterpreter.hasJobList() && urlInterpreter.hasAttribute() && request.getMethod().equalsIgnoreCase("get");
    }

    @Override
    public boolean apply(UWSUrl urlInterpreter, String userId, HttpServletRequest request, HttpServletResponse response) throws UWSException, IOException {
        Object job = this.getJob(urlInterpreter);
        UWSSerializer serializer = this.uws.getSerializer(request.getHeader("Accept"));
        String attribute = urlInterpreter.getAttributes()[0];
        if (attribute == null || attribute.trim().isEmpty() || urlInterpreter.getAttributes().length <= 1 && (attribute.equalsIgnoreCase("error") || attribute.equalsIgnoreCase("results") || attribute.equalsIgnoreCase("parameters"))) {
            response.setContentType(serializer.getMimeType());
        } else {
            response.setContentType("text/plain");
        }
        ((AbstractJob)job).serialize((OutputStream)response.getOutputStream(), urlInterpreter.getAttributes(), serializer);
        return true;
    }
}

