/*
 * Decompiled with CFR 0.152.
 */
package uws.service.actions;

import java.io.IOException;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import uws.UWSException;
import uws.UWSToolBox;
import uws.job.AbstractJob;
import uws.job.JobList;
import uws.service.AbstractUWS;
import uws.service.UWSUrl;
import uws.service.actions.UWSAction;

public class AddJob<JL extends JobList<J>, J extends AbstractJob>
extends UWSAction<JL, J> {
    private static final long serialVersionUID = 1L;

    public AddJob(AbstractUWS<JL, J> u) {
        super(u);
    }

    @Override
    public String getName() {
        return "Add Job";
    }

    @Override
    public String getDescription() {
        return "Lets adding to the specified jobs list a job whose the parameters are given. (URL: {baseUWS_URL}/{jobListName}, Method: HTTP-POST, Parameters: job parameters)";
    }

    @Override
    public boolean match(UWSUrl urlInterpreter, String userId, HttpServletRequest request) throws UWSException {
        return urlInterpreter.hasJobList() && !urlInterpreter.hasJob() && request.getMethod().equalsIgnoreCase("post");
    }

    @Override
    public boolean apply(UWSUrl urlInterpreter, String userId, HttpServletRequest request, HttpServletResponse response) throws UWSException, IOException {
        Object jobsList = this.getJobsList(urlInterpreter);
        Map<String, String> params = UWSToolBox.getParamsMap(request, userId);
        this.uws.getExecutionDurationController().init(params);
        this.uws.getDestructionTimeController().init(params);
        Object newJob = this.uws.createJob(params);
        ((AbstractJob)newJob).setExecutionManager(this.uws.getExecutionManager());
        if (((JobList)jobsList).addNewJob(newJob) != null) {
            this.uws.redirect(urlInterpreter.jobSummary(((JobList)jobsList).getName(), ((AbstractJob)newJob).getJobId()).getRequestURL(), request, response);
            return true;
        }
        throw new UWSException(500, "[" + this.getName() + "] Unable to add the new job to the jobs list. (ID of the new job = \"" + ((AbstractJob)newJob).getJobId() + "\" ; ID already used = " + (((JobList)jobsList).getJob(((AbstractJob)newJob).getJobId()) != null) + ")");
    }
}

