/*
 * Decompiled with CFR 0.152.
 */
package uws.job.serializer;

import java.io.Serializable;
import java.util.Iterator;
import uws.UWSException;
import uws.job.AbstractJob;
import uws.job.ErrorSummary;
import uws.job.ErrorType;
import uws.job.JobList;
import uws.job.Result;
import uws.service.AbstractUWS;

public abstract class UWSSerializer
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String MIME_TYPE_XML = "application/xml";
    public static final String MIME_TYPE_JSON = "application/json";
    public static final String MIME_TYPE_TEXT = "text/plain";
    public static final String MIME_TYPE_HTML = "text/html";

    public String getJob(AbstractJob job, String[] attributes, boolean root) throws UWSException {
        if (attributes == null || attributes.length <= 0) {
            return this.getJob(job, root);
        }
        String firstAttribute = attributes[0];
        if (firstAttribute.equalsIgnoreCase("jobId")) {
            return job.getJobId();
        }
        if (firstAttribute.equalsIgnoreCase("runid")) {
            return job.getRunId() == null ? "" : job.getRunId();
        }
        if (firstAttribute.equalsIgnoreCase("owner")) {
            return job.getOwner() == null ? "" : job.getOwner();
        }
        if (firstAttribute.equalsIgnoreCase("phase")) {
            return job.getPhase().toString();
        }
        if (firstAttribute.equalsIgnoreCase("quote")) {
            return String.valueOf(job.getQuote());
        }
        if (firstAttribute.equalsIgnoreCase("startTime")) {
            return job.getStartTime() == null ? "" : job.getDateFormat().format(job.getStartTime());
        }
        if (firstAttribute.equalsIgnoreCase("endTime")) {
            return job.getEndTime() == null ? "" : job.getDateFormat().format(job.getEndTime());
        }
        if (firstAttribute.equalsIgnoreCase("executionduration")) {
            return String.valueOf(job.getExecutionDuration());
        }
        if (firstAttribute.equalsIgnoreCase("destruction")) {
            return job.getDestructionTime() == null ? "" : job.getDateFormat().format(job.getDestructionTime());
        }
        if (firstAttribute.equalsIgnoreCase("parameters")) {
            if (attributes.length <= 1) {
                return this.getAdditionalParameters(job, root);
            }
            String secondAttribute = attributes[1];
            for (String paramName : job.getAdditionalParameters()) {
                if (!paramName.equalsIgnoreCase(secondAttribute)) continue;
                return job.getAdditionalParameterValue(paramName);
            }
            throw new UWSException(404, "[Get Job Parameter] The parameter \"" + secondAttribute + "\" does not exist for the job \"" + job.getJobId() + "\" !", ErrorType.TRANSIENT);
        }
        if (firstAttribute.equalsIgnoreCase("results")) {
            if (attributes.length <= 1) {
                return this.getResults(job, root);
            }
            String secondAttribute = attributes[1];
            Iterator<Result> it = job.getResults();
            while (it.hasNext()) {
                Result result = it.next();
                if (!result.getId().equalsIgnoreCase(secondAttribute)) continue;
                throw new UWSException(303, result.getHref());
            }
            throw new UWSException(404, "[Get Job Parameter] There is no result identified by \"" + secondAttribute + "\" !", ErrorType.TRANSIENT);
        }
        if (firstAttribute.equalsIgnoreCase("error")) {
            if (job.getErrorSummary().hasDetail()) {
                throw new UWSException(303, job.getErrorSummary().getDetails().toString());
            }
            return this.getErrorSummary(job.getErrorSummary(), root);
        }
        throw new UWSException(404, "[Get Job Parameter] The job parameter \"" + firstAttribute + "\" doesn't exist !", ErrorType.TRANSIENT);
    }

    public String toString() {
        return this.getMimeType();
    }

    public abstract String getMimeType();

    public String getUWS(AbstractUWS<? extends JobList<? extends AbstractJob>, ? extends AbstractJob> uws) throws UWSException {
        return this.getUWS(uws, null);
    }

    public abstract String getUWS(AbstractUWS<? extends JobList<? extends AbstractJob>, ? extends AbstractJob> var1, String var2) throws UWSException;

    public String getJobList(JobList<? extends AbstractJob> jobsList, boolean root) throws UWSException {
        return this.getJobList(jobsList, null, root);
    }

    public abstract String getJobList(JobList<? extends AbstractJob> var1, String var2, boolean var3) throws UWSException;

    public abstract String getJob(AbstractJob var1, boolean var2) throws UWSException;

    public abstract String getJobID(AbstractJob var1, boolean var2) throws UWSException;

    public abstract String getRunID(AbstractJob var1, boolean var2) throws UWSException;

    public abstract String getOwnerID(AbstractJob var1, boolean var2) throws UWSException;

    public abstract String getPhase(AbstractJob var1, boolean var2) throws UWSException;

    public abstract String getQuote(AbstractJob var1, boolean var2) throws UWSException;

    public abstract String getStartTime(AbstractJob var1, boolean var2) throws UWSException;

    public abstract String getEndTime(AbstractJob var1, boolean var2) throws UWSException;

    public abstract String getExecutionDuration(AbstractJob var1, boolean var2) throws UWSException;

    public abstract String getDestructionTime(AbstractJob var1, boolean var2) throws UWSException;

    public abstract String getErrorSummary(ErrorSummary var1, boolean var2) throws UWSException;

    public abstract String getResults(AbstractJob var1, boolean var2) throws UWSException;

    public abstract String getResult(Result var1, boolean var2) throws UWSException;

    public abstract String getAdditionalParameters(AbstractJob var1, boolean var2) throws UWSException;

    public abstract String getAdditionalParameter(String var1, String var2, boolean var3) throws UWSException;
}

