/*
 * Decompiled with CFR 0.152.
 */
package uws.job.serializer;

import java.util.Iterator;
import uws.UWSException;
import uws.job.AbstractJob;
import uws.job.ErrorSummary;
import uws.job.JobList;
import uws.job.Result;
import uws.job.serializer.UWSSerializer;
import uws.service.AbstractUWS;
import uws.service.UWSUrl;

public class JSONSerializer
extends UWSSerializer {
    private static final long serialVersionUID = 1L;
    protected String tabPrefix = "";

    @Override
    public final String getMimeType() {
        return "application/json";
    }

    @Override
    public String getUWS(AbstractUWS<? extends JobList<? extends AbstractJob>, ? extends AbstractJob> uws, String userId) throws UWSException {
        String json = "{\n\t\"name\": \"" + uws.getName() + "\",";
        if (uws.getDescription() != null) {
            json = String.valueOf(json) + "\n\t\"description\": \"" + uws.getDescription() + "\",";
        }
        json = String.valueOf(json) + "\n\t\"jobLists\": [";
        Iterator<? extends JobList<? extends AbstractJob>> it = uws.iterator();
        while (it.hasNext()) {
            JobList<? extends AbstractJob> jobList = it.next();
            UWSUrl jlUrl = jobList.getUrl();
            String url = jlUrl == null ? null : jlUrl.getRequestURL();
            json = String.valueOf(json) + "\n\t\t{ \"name\": \"" + jobList.getName() + "\", \"href\": " + (url == null ? "" : url) + "\" }" + (it.hasNext() ? "," : "");
        }
        return String.valueOf(json) + "\n\t]\n}";
    }

    @Override
    public String getJobList(JobList<? extends AbstractJob> jobsList, String ownerId, boolean root) throws UWSException {
        UWSUrl jobsListUrl = jobsList.getUrl();
        String json = "{\n\t\"name\": \"" + jobsList.getName() + "\",\n\t\"jobs\": [";
        Iterator<? extends AbstractJob> it = jobsList.getJobs(ownerId);
        while (it.hasNext()) {
            AbstractJob j = it.next();
            String url = null;
            if (jobsListUrl != null) {
                jobsListUrl.setJobId(j.getJobId());
                url = jobsListUrl.getRequestURL();
            }
            json = String.valueOf(json) + "\n\t\t{ \"id\": \"" + j.getJobId() + "\", \"href\": \"" + (url == null ? "" : url) + "\", " + this.getPhase(j, false) + " }" + (it.hasNext() ? "," : "");
        }
        json = String.valueOf(json) + "\n\t]\n}";
        return json;
    }

    @Override
    public String getJob(AbstractJob job, boolean root) throws UWSException {
        String json = "{ \n\t" + this.getJobID(job, false) + ",\n\t" + this.getRunID(job, false) + ",\n\t" + this.getOwnerID(job, false) + ",\n\t" + this.getPhase(job, false) + ",\n\t" + this.getQuote(job, false) + ",\n\t" + this.getStartTime(job, false) + ",\n\t" + this.getEndTime(job, false) + ",\n\t" + this.getExecutionDuration(job, false) + ",\n\t" + this.getDestructionTime(job, false);
        this.tabPrefix = String.valueOf(this.tabPrefix) + "\t";
        json = String.valueOf(json) + ",\n" + this.getAdditionalParameters(job, false);
        json = String.valueOf(json) + ",\n" + this.getResults(job, false);
        if (job.getErrorSummary() != null) {
            json = String.valueOf(json) + ",\n" + this.getErrorSummary(job.getErrorSummary(), false);
        }
        this.tabPrefix = "";
        return String.valueOf(json) + "\n}";
    }

    @Override
    public String getJobID(AbstractJob job, boolean root) throws UWSException {
        String json = "\"jobId\": \"" + job.getJobId() + "\"";
        return root ? "{ " + json + " }" : json;
    }

    @Override
    public String getRunID(AbstractJob job, boolean root) throws UWSException {
        String json = "\"runId\": \"" + (job.getRunId() == null ? "" : job.getRunId()) + "\"";
        return root ? "{ " + json + " }" : json;
    }

    @Override
    public String getOwnerID(AbstractJob job, boolean root) throws UWSException {
        String json = "\"owner\": \"" + (job.getOwner() == null ? "" : job.getOwner()) + "\"";
        return root ? "{ " + json + " }" : json;
    }

    @Override
    public String getPhase(AbstractJob job, boolean root) throws UWSException {
        String json = "\"phase\": \"" + (Object)((Object)job.getPhase()) + "\"";
        return root ? "{ " + json + " }" : json;
    }

    @Override
    public String getQuote(AbstractJob job, boolean root) throws UWSException {
        String json = "\"quote\": \"" + job.getQuote() + "\"";
        return root ? "{ " + json + " }" : json;
    }

    @Override
    public String getExecutionDuration(AbstractJob job, boolean root) throws UWSException {
        String json = "\"executionDuration\": \"" + job.getExecutionDuration() + "\"";
        return root ? "{ " + json + " }" : json;
    }

    @Override
    public String getDestructionTime(AbstractJob job, boolean root) throws UWSException {
        String json = "\"destruction\": \"" + (job.getDestructionTime() != null ? job.getDateFormat().format(job.getDestructionTime()) : "") + "\"";
        return root ? "{ " + json + " }" : json;
    }

    @Override
    public String getStartTime(AbstractJob job, boolean root) throws UWSException {
        String json = "\"startTime\": \"" + (job.getStartTime() != null ? job.getDateFormat().format(job.getStartTime()) : "") + "\"";
        return root ? "{ " + json + " }" : json;
    }

    @Override
    public String getEndTime(AbstractJob job, boolean root) throws UWSException {
        String json = "\"endTime\": \"" + (job.getEndTime() != null ? job.getDateFormat().format(job.getEndTime()) : "") + "\"";
        return root ? "{ " + json + " }" : json;
    }

    @Override
    public String getErrorSummary(ErrorSummary error, boolean root) throws UWSException {
        String json = "\"error\": {";
        json = error == null ? String.valueOf(json) + "}" : "\n\t" + this.tabPrefix + "\"type\": \"" + (Object)((Object)error.getType()) + "\",\n\t" + this.tabPrefix + "\"hasDetail\": \"" + error.hasDetail() + "\",\n\t" + this.tabPrefix + "\"message\": \"" + error.getMessage().replaceAll("\"", "'") + "\"\n" + this.tabPrefix + "}";
        return String.valueOf(this.tabPrefix) + (root ? "{ " + json + " }" : json);
    }

    @Override
    public String getAdditionalParameters(AbstractJob job, boolean root) throws UWSException {
        String json = null;
        for (String paramName : job.getAdditionalParameters()) {
            json = json == null ? "\n\t" + this.tabPrefix : String.valueOf(json) + "\t,";
            json = String.valueOf(json) + this.getAdditionalParameter(paramName, job.getAdditionalParameterValue(paramName), false) + "\n" + this.tabPrefix;
        }
        return String.valueOf(this.tabPrefix) + (root ? "{ " : "") + "\"parameters\": [" + (json == null ? "" : json) + "]" + (root ? "\n" + this.tabPrefix + "}" : "");
    }

    @Override
    public String getAdditionalParameter(String paramName, String paramValue, boolean root) throws UWSException {
        String json = "\"" + paramName + "\": \"" + paramValue + "\"";
        return root ? "{ " + json + " }" : json;
    }

    @Override
    public String getResults(AbstractJob job, boolean root) throws UWSException {
        String json = null;
        String oldTabPrefix = this.tabPrefix;
        Iterator<Result> it = job.getResults();
        while (it.hasNext()) {
            json = json == null ? "\n\t" + this.tabPrefix : String.valueOf(json) + "\t,";
            json = String.valueOf(json) + this.getResult(it.next(), false) + "\n" + this.tabPrefix;
        }
        this.tabPrefix = oldTabPrefix;
        return String.valueOf(this.tabPrefix) + (root ? "{ " : "") + "\"results\": [" + (json == null ? "" : json) + "]" + (root ? "\n" + this.tabPrefix + "}" : "");
    }

    @Override
    public String getResult(Result result, boolean root) throws UWSException {
        String json = "{ \"id\": \"" + result.getId() + "\", \"type\": \"" + result.getType() + "\", \"href\": \"" + result.getHref() + "\" }";
        return root ? "{ " + json + " }" : json;
    }
}

