/*
 * Decompiled with CFR 0.152.
 */
package uws.job.manager;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import uws.UWSException;
import uws.job.AbstractJob;
import uws.job.ErrorType;
import uws.job.ExecutionPhase;
import uws.job.manager.ExecutionManager;

public class DefaultExecutionManager
implements ExecutionManager {
    private static final long serialVersionUID = 1L;
    protected transient Map<String, AbstractJob> runningJobs;

    public DefaultExecutionManager() {
        this.sync();
    }

    @Override
    public synchronized void sync() {
        if (this.runningJobs == null) {
            this.runningJobs = new LinkedHashMap<String, AbstractJob>();
        }
    }

    @Override
    public final synchronized Iterator<AbstractJob> getRunningJobs() {
        if (this.runningJobs == null) {
            this.sync();
        }
        return this.runningJobs.values().iterator();
    }

    @Override
    public final synchronized int getNbRunningJobs() {
        if (this.runningJobs == null) {
            this.sync();
        }
        return this.runningJobs.size();
    }

    @Override
    public synchronized Iterator<AbstractJob> getQueuedJobs() {
        return new Iterator<AbstractJob>(){

            @Override
            public boolean hasNext() {
                return false;
            }

            @Override
            public AbstractJob next() {
                return null;
            }

            @Override
            public void remove() {
            }
        };
    }

    @Override
    public synchronized int getNbQueuedJobs() {
        return 0;
    }

    @Override
    public void setNoQueue() {
    }

    @Override
    public boolean hasQueue() {
        return false;
    }

    @Override
    public synchronized void refresh() throws UWSException {
        if (this.runningJobs == null) {
            this.sync();
        }
    }

    @Override
    public synchronized ExecutionPhase execute(AbstractJob jobToExecute) throws UWSException {
        if (jobToExecute == null) {
            return null;
        }
        try {
            this.refresh();
        }
        catch (UWSException ue) {
            ue.printStackTrace();
        }
        if (jobToExecute.isRunning()) {
            this.runningJobs.put(jobToExecute.getJobId(), jobToExecute);
        } else {
            if (jobToExecute.isFinished()) {
                this.runningJobs.remove(jobToExecute);
                throw new UWSException(400, "[Start a job] The job \"" + jobToExecute.getJobId() + "\" has already been executed. It has finished with the phase \"" + (Object)((Object)jobToExecute.getPhase()) + "\" !", ErrorType.TRANSIENT);
            }
            jobToExecute.start(false);
            this.runningJobs.put(jobToExecute.getJobId(), jobToExecute);
        }
        return jobToExecute.getPhase();
    }

    @Override
    public boolean isReadyForExecution(AbstractJob jobToExecute) {
        if (this.runningJobs == null) {
            this.sync();
        }
        return jobToExecute != null && !jobToExecute.isFinished();
    }

    @Override
    public synchronized void update(AbstractJob job) throws UWSException {
        if (this.runningJobs == null) {
            this.sync();
        }
        if (job == null || job.isFinished()) {
            return;
        }
        if (job.isRunning()) {
            this.runningJobs.put(job.getJobId(), job);
        }
        this.refresh();
    }

    @Override
    public synchronized void remove(AbstractJob jobToRemove) throws UWSException {
        if (this.runningJobs == null) {
            this.sync();
        }
        if (jobToRemove == null) {
            return;
        }
        this.runningJobs.remove(jobToRemove.getJobId());
        this.refresh();
    }
}

