/*
 * Decompiled with CFR 0.152.
 */
package uws.job;

import java.util.Date;
import uws.UWSException;
import uws.UWSToolBox;
import uws.job.AbstractJob;
import uws.job.ErrorSummary;
import uws.job.ErrorType;
import uws.job.ExecutionPhase;

public class JobThread
extends Thread {
    protected final AbstractJob job;
    protected UWSException lastError = null;
    protected boolean finished = false;

    public JobThread(AbstractJob j) throws UWSException {
        if (j == null) {
            throw new UWSException(500, "[Create a JobThread] A JobThread object can not exist without a Job instance !");
        }
        this.job = j;
    }

    public final AbstractJob getExecutedJob() {
        return this.job;
    }

    public final UWSException getError() {
        return this.lastError;
    }

    public final boolean isFinished() {
        return this.finished;
    }

    private final void complete() throws UWSException {
        if (this.isInterrupted()) {
            this.job.abort();
        } else {
            this.job.setPhase(ExecutionPhase.COMPLETED);
            this.job.setEndTime(new Date());
        }
    }

    /*
     * Loose catch block
     */
    @Override
    public void run() {
        block35: {
            block34: {
                if (!this.job.getPhaseManager().isExecuting()) {
                    return;
                }
                this.lastError = null;
                this.finished = false;
                try {
                    this.job.jobWork();
                    this.finished = true;
                    this.complete();
                }
                catch (InterruptedException ex) {
                    this.finished = true;
                    this.job.abort();
                }
                this.finished = true;
                if (this.lastError == null) break block34;
                try {
                    this.job.error(this.lastError);
                }
                catch (UWSException ue) {
                    this.lastError.printStackTrace();
                    try {
                        System.err.println("### [UWS ERROR - JobThread] LEVEL 1 -> Problem in " + this.job.getClass().getName() + ".publishExecutionError(UWSException) ###");
                        ue.printStackTrace();
                        UWSToolBox.publishErrorSummary(this.job, this.lastError.getCause() != null ? this.lastError.getCause().getMessage() : this.lastError.getMessage(), this.lastError.getUWSErrorType());
                    }
                    catch (UWSException ue2) {
                        System.err.println("### [UWS ERROR - JobThread] LEVEL 2 -> Problem in UWSToolBox.publishErrorSummary(AbstractJob, String, ErrorType) ###");
                        ue2.printStackTrace();
                        try {
                            this.job.error(new ErrorSummary(this.lastError.getMessage(), ErrorType.FATAL));
                        }
                        catch (UWSException ue3) {
                            System.err.println("### [UWS ERROR - JobThread] LEVEL 3 -> Problem in " + this.job.getClass().getName() + ".error(ErrorSummary) or in ErrorSummary.ErrorSummary(String, ErrorType) ###");
                            ue3.printStackTrace();
                        }
                    }
                }
            }
            return;
            catch (UWSException ue) {
                this.lastError = ue;
                this.finished = true;
                if (this.lastError == null) break block35;
                try {
                    this.job.error(this.lastError);
                }
                catch (UWSException ue2) {
                    this.lastError.printStackTrace();
                    try {
                        System.err.println("### [UWS ERROR - JobThread] LEVEL 1 -> Problem in " + this.job.getClass().getName() + ".publishExecutionError(UWSException) ###");
                        ue2.printStackTrace();
                        UWSToolBox.publishErrorSummary(this.job, this.lastError.getCause() != null ? this.lastError.getCause().getMessage() : this.lastError.getMessage(), this.lastError.getUWSErrorType());
                        break block35;
                    }
                    catch (UWSException ue22) {
                        System.err.println("### [UWS ERROR - JobThread] LEVEL 2 -> Problem in UWSToolBox.publishErrorSummary(AbstractJob, String, ErrorType) ###");
                        ue22.printStackTrace();
                        try {
                            this.job.error(new ErrorSummary(this.lastError.getMessage(), ErrorType.FATAL));
                            break block35;
                        }
                        catch (UWSException ue3) {
                            System.err.println("### [UWS ERROR - JobThread] LEVEL 3 -> Problem in " + this.job.getClass().getName() + ".error(ErrorSummary) or in ErrorSummary.ErrorSummary(String, ErrorType) ###");
                            ue3.printStackTrace();
                        }
                    }
                }
            }
            catch (Throwable t) {
                this.lastError = t.getMessage() == null ? new UWSException(500, t.getClass().getName(), ErrorType.FATAL) : new UWSException(500, t, ErrorType.FATAL);
                this.finished = true;
                if (this.lastError == null) break block35;
                {
                    catch (Throwable throwable) {
                        this.finished = true;
                        if (this.lastError != null) {
                            try {
                                this.job.error(this.lastError);
                            }
                            catch (UWSException ue2) {
                                this.lastError.printStackTrace();
                                try {
                                    System.err.println("### [UWS ERROR - JobThread] LEVEL 1 -> Problem in " + this.job.getClass().getName() + ".publishExecutionError(UWSException) ###");
                                    ue2.printStackTrace();
                                    UWSToolBox.publishErrorSummary(this.job, this.lastError.getCause() != null ? this.lastError.getCause().getMessage() : this.lastError.getMessage(), this.lastError.getUWSErrorType());
                                }
                                catch (UWSException ue22) {
                                    System.err.println("### [UWS ERROR - JobThread] LEVEL 2 -> Problem in UWSToolBox.publishErrorSummary(AbstractJob, String, ErrorType) ###");
                                    ue22.printStackTrace();
                                    try {
                                        this.job.error(new ErrorSummary(this.lastError.getMessage(), ErrorType.FATAL));
                                    }
                                    catch (UWSException ue3) {
                                        System.err.println("### [UWS ERROR - JobThread] LEVEL 3 -> Problem in " + this.job.getClass().getName() + ".error(ErrorSummary) or in ErrorSummary.ErrorSummary(String, ErrorType) ###");
                                        ue3.printStackTrace();
                                    }
                                }
                            }
                        }
                        throw throwable;
                    }
                }
                try {
                    this.job.error(this.lastError);
                }
                catch (UWSException ue3) {
                    this.lastError.printStackTrace();
                    try {
                        System.err.println("### [UWS ERROR - JobThread] LEVEL 1 -> Problem in " + this.job.getClass().getName() + ".publishExecutionError(UWSException) ###");
                        ue3.printStackTrace();
                        UWSToolBox.publishErrorSummary(this.job, this.lastError.getCause() != null ? this.lastError.getCause().getMessage() : this.lastError.getMessage(), this.lastError.getUWSErrorType());
                    }
                    catch (UWSException ue2) {
                        System.err.println("### [UWS ERROR - JobThread] LEVEL 2 -> Problem in UWSToolBox.publishErrorSummary(AbstractJob, String, ErrorType) ###");
                        ue2.printStackTrace();
                        try {
                            this.job.error(new ErrorSummary(this.lastError.getMessage(), ErrorType.FATAL));
                        }
                        catch (UWSException ue32) {
                            System.err.println("### [UWS ERROR - JobThread] LEVEL 3 -> Problem in " + this.job.getClass().getName() + ".error(ErrorSummary) or in ErrorSummary.ErrorSummary(String, ErrorType) ###");
                            ue32.printStackTrace();
                        }
                    }
                }
            }
        }
    }
}

