/*
 * Decompiled with CFR 0.152.
 */
package uws.job;

import java.io.Serializable;
import uws.UWSException;
import uws.job.AbstractJob;
import uws.job.ExecutionPhase;

public class JobPhase
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected ExecutionPhase phase = ExecutionPhase.PENDING;
    protected final AbstractJob job;

    public JobPhase(AbstractJob j) throws UWSException {
        if (j == null) {
            throw new UWSException(500, "[Create a JobPhase] Impossible to build a JobPhase object without a valid AbstractJob instance (different from NULL) !");
        }
        this.job = j;
    }

    public final AbstractJob getJob() {
        return this.job;
    }

    public final ExecutionPhase getPhase() {
        return this.phase;
    }

    public final void setPhase(ExecutionPhase p) throws UWSException {
        this.setPhase(p, false);
    }

    public void setPhase(ExecutionPhase p, boolean force) throws UWSException {
        if (p == null) {
            throw new UWSException(500, "[Change phase] The phase of this job can not be set to NULL !");
        }
        switch (p) {
            case PENDING: {
                this.setPendingPhase(force);
                break;
            }
            case QUEUED: {
                this.setQueuedPhase(force);
                break;
            }
            case EXECUTING: {
                this.setExecutingPhase(force);
                break;
            }
            case COMPLETED: {
                this.setCompletedPhase(force);
                break;
            }
            case ABORTED: {
                this.setAbortedPhase(force);
                break;
            }
            case ERROR: {
                this.setErrorPhase(force);
                break;
            }
            case HELD: {
                this.setHeldPhase(force);
                break;
            }
            case SUSPENDED: {
                this.setSuspendedPhase(force);
                break;
            }
            default: {
                this.setUnknownPhase(force);
            }
        }
    }

    protected void setPendingPhase(boolean force) throws UWSException {
        if (!force && this.phase != ExecutionPhase.PENDING && this.phase != ExecutionPhase.UNKNOWN) {
            throw new UWSException(400, "[Change phase] Impossible to go back to the PENDING phase from the phase " + ExecutionPhase.getStr(this.phase) + ".");
        }
        this.phase = ExecutionPhase.PENDING;
    }

    protected void setQueuedPhase(boolean force) throws UWSException {
        if (force) {
            this.phase = ExecutionPhase.QUEUED;
        } else {
            if (this.phase != ExecutionPhase.QUEUED && this.phase != ExecutionPhase.HELD && this.phase != ExecutionPhase.PENDING && this.phase != ExecutionPhase.UNKNOWN) {
                throw new UWSException(400, "[Change phase] Impossible to go back to the QUEUED phase from the phase " + ExecutionPhase.getStr(this.phase) + ". The only way to go to this phase is by sending a POST query with the value RUN for the parameter PHASE while the current phase is PENDING or HELD.");
            }
            this.phase = ExecutionPhase.QUEUED;
        }
    }

    protected void setExecutingPhase(boolean force) throws UWSException {
        if (force) {
            this.phase = ExecutionPhase.EXECUTING;
        } else {
            if (this.phase != ExecutionPhase.EXECUTING && this.phase != ExecutionPhase.SUSPENDED && this.phase != ExecutionPhase.PENDING && this.phase != ExecutionPhase.QUEUED && this.phase != ExecutionPhase.UNKNOWN) {
                throw new UWSException(400, "[Change phase] Impossible to go to the EXECUTING phase from the phase " + ExecutionPhase.getStr(this.phase) + ". The only way to go to this phase is from the phases PENDING, QUEUED OR SUSPENDED.");
            }
            this.phase = ExecutionPhase.EXECUTING;
        }
    }

    protected void setCompletedPhase(boolean force) throws UWSException {
        if (force) {
            this.phase = ExecutionPhase.COMPLETED;
        } else {
            if (this.phase != ExecutionPhase.COMPLETED && this.phase != ExecutionPhase.EXECUTING && this.phase != ExecutionPhase.UNKNOWN) {
                throw new UWSException(400, "[Change phase] Impossible to go to the COMPLETED phase from the phase " + ExecutionPhase.getStr(this.phase) + ". The only way to go to this phase is from the phase EXECUTING.");
            }
            this.phase = ExecutionPhase.COMPLETED;
        }
    }

    protected void setAbortedPhase(boolean force) throws UWSException {
        if (force) {
            this.phase = ExecutionPhase.ABORTED;
        } else {
            if (this.phase == ExecutionPhase.COMPLETED) {
                throw new UWSException(400, "[Change phase] The job is already (successfully) finished so it is impossible to change its phase.");
            }
            if (this.phase == ExecutionPhase.ERROR) {
                throw new UWSException(400, "[Change phase] The job is already finished (with an error) so it is impossible to change its phase.");
            }
            this.phase = ExecutionPhase.ABORTED;
        }
    }

    protected void setErrorPhase(boolean force) throws UWSException {
        if (force) {
            this.phase = ExecutionPhase.ERROR;
        } else {
            if (this.phase == ExecutionPhase.COMPLETED) {
                throw new UWSException(400, "[Change phase] The job is (successfully) finished so it is impossible to change its phase.");
            }
            if (this.phase == ExecutionPhase.ABORTED) {
                throw new UWSException(400, "[Change phase] The job has been aborted so it is impossible to change its phase.");
            }
            this.phase = ExecutionPhase.ERROR;
        }
    }

    protected void setHeldPhase(boolean force) throws UWSException {
        if (!force && this.phase != ExecutionPhase.HELD && this.phase != ExecutionPhase.PENDING && this.phase != ExecutionPhase.UNKNOWN) {
            throw new UWSException(400, "[Change phase] Impossible to go back to the HELD phase from the phase " + ExecutionPhase.getStr(this.phase) + ". The only way to go to this phase is by sending a POST query with the value RUN for the parameter PHASE while the current phase is PENDING and if the job can not be set to the QUEUED phase.");
        }
        this.phase = ExecutionPhase.HELD;
    }

    protected void setSuspendedPhase(boolean force) throws UWSException {
        this.phase = ExecutionPhase.SUSPENDED;
    }

    protected void setUnknownPhase(boolean force) throws UWSException {
        this.phase = ExecutionPhase.UNKNOWN;
    }

    public boolean isJobUpdatable() {
        return this.phase == ExecutionPhase.PENDING;
    }

    public boolean isFinished() {
        return this.phase == ExecutionPhase.COMPLETED || this.phase == ExecutionPhase.ABORTED || this.phase == ExecutionPhase.ERROR;
    }

    public boolean isExecuting() {
        return this.phase == ExecutionPhase.EXECUTING;
    }

    public String toString() {
        return ExecutionPhase.getStr(this.phase);
    }
}

