/*
 * Decompiled with CFR 0.152.
 */
package uws.job;

import java.io.IOException;
import java.io.OutputStream;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.Vector;
import uws.UWSException;
import uws.UWSToolBox;
import uws.job.ErrorSummary;
import uws.job.ErrorType;
import uws.job.ExecutionPhase;
import uws.job.JobList;
import uws.job.JobObserver;
import uws.job.JobPhase;
import uws.job.JobThread;
import uws.job.Result;
import uws.job.SerializableUWSObject;
import uws.job.manager.ExecutionManager;
import uws.job.serializer.UWSSerializer;

public abstract class AbstractJob
extends SerializableUWSObject {
    private static final long serialVersionUID = 1L;
    public static final String PARAM_ACTION = "ACTION";
    public static final String ACTION_DELETE = "DELETE";
    public static final String PARAM_RUN_ID = "runid";
    public static final String PARAM_OWNER = "owner";
    public static final String PARAM_PHASE = "phase";
    public static final String PHASE_RUN = "RUN";
    public static final String PHASE_ABORT = "ABORT";
    public static final String PARAM_QUOTE = "quote";
    public static final String PARAM_EXECUTION_DURATION = "executionduration";
    public static final String PARAM_DESTRUCTION_TIME = "destruction";
    public static final String PARAM_ERROR_SUMMARY = "error";
    public static final String PARAM_PARAMETERS = "parameters";
    public static final String PARAM_RESULTS = "results";
    public static final String ANONYMOUS_OWNER = "anonymous";
    public static final String DEFAULT_DATE_FORMAT = "yyyy-MM-dd'T'HH:mm:ss.SSSZ";
    public static final long QUOTE_NOT_KNOWN = -1L;
    public static final long UNLIMITED_DURATION = 0L;
    protected static String lastId = null;
    protected final String jobId;
    protected final String owner;
    protected String runId = null;
    private JobPhase phase;
    protected DateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ");
    private long quote = -1L;
    private Date startTime = null;
    private Date endTime = null;
    private long executionDuration = 0L;
    private transient Timer timExecDuration;
    private Date destructionTime = null;
    protected ErrorSummary errorSummary = null;
    protected Map<String, String> additionalParameters;
    protected List<Result> results;
    protected transient JobThread thread = null;
    protected long waitForStop = 1000L;
    private ExecutionManager executionManager = null;
    private JobList<AbstractJob> myJobList = null;
    private Vector<JobObserver> observers = new Vector();
    private transient String syncStatus = "SYNCHRONIZED";

    public AbstractJob(Map<String, String> lstParam) throws UWSException {
        this(null, lstParam);
    }

    protected AbstractJob(String ownerID, Map<String, String> lstParam) throws UWSException {
        this(null, ownerID != null ? ownerID : (lstParam.containsKey(PARAM_OWNER) ? lstParam.get(PARAM_OWNER) : null), 0L, null, lstParam);
    }

    protected AbstractJob(String jobName, String ownerId, long maxDuration, Date destructTime, Map<String, String> lstParam) throws UWSException {
        this.runId = jobName;
        this.owner = ownerId == null ? ANONYMOUS_OWNER : ownerId;
        this.phase = new JobPhase(this);
        this.executionDuration = maxDuration < 0L ? 0L : maxDuration;
        this.setDestructionTime(destructTime);
        this.additionalParameters = new HashMap<String, String>();
        this.results = new Vector<Result>();
        Map<String, String> others = this.loadDefaultParams(lstParam);
        if (others != null) {
            this.additionalParameters.putAll(others);
        }
        this.jobId = this.generateJobId();
    }

    protected AbstractJob(String jobId, String jobName, String ownerId, ExecutionPhase phase, Date startTime, Date endTime, long maxDuration, Date destructTime, List<Result> results, ErrorSummary errors, Map<String, String> additionalParams) throws UWSException {
        if (jobId == null) {
            throw new UWSException(500, "[Create an AbstractJob] Impossible to build a Job with a NULL ID !");
        }
        this.jobId = jobId;
        this.runId = jobName;
        this.owner = ownerId == null ? ANONYMOUS_OWNER : ownerId;
        this.startTime = startTime;
        this.endTime = endTime;
        this.phase = new JobPhase(this);
        if (phase != null) {
            this.setPhase(phase, true);
        }
        this.executionDuration = maxDuration;
        this.setDestructionTime(destructTime);
        this.additionalParameters = new HashMap<String, String>();
        if (additionalParams != null) {
            this.additionalParameters.putAll(additionalParams);
        }
        this.results = new Vector<Result>();
        if (results != null) {
            this.results.addAll(results);
        }
        this.errorSummary = errors;
    }

    public final synchronized boolean sync() {
        if (this.syncStatus == null && (this.phase.getPhase() == ExecutionPhase.EXECUTING || this.phase.getPhase() == ExecutionPhase.QUEUED)) {
            try {
                this.setPhase(ExecutionPhase.PENDING, true);
            }
            catch (UWSException ex) {
                ex.printStackTrace();
                return false;
            }
            try {
                this.clearResources();
            }
            catch (Exception ex) {
                ex.printStackTrace();
                return false;
            }
            this.errorSummary = null;
            this.results.clear();
            this.startTime = null;
            this.endTime = null;
        }
        this.syncStatus = "SYNCHRONIZED";
        return true;
    }

    protected String generateJobId() {
        String generatedId = String.valueOf(System.currentTimeMillis()) + "A";
        if (lastId != null) {
            while (lastId.equals(generatedId)) {
                generatedId = String.valueOf(generatedId.substring(0, generatedId.length() - 1)) + (char)(generatedId.charAt(generatedId.length() - 1) + '\u0001');
            }
        }
        lastId = generatedId;
        return generatedId;
    }

    protected Map<String, String> loadDefaultParams(Map<String, String> lstParam) throws UWSException {
        if (lstParam == null) {
            return new HashMap<String, String>();
        }
        HashMap<String, String> params = new HashMap<String, String>();
        for (String key : lstParam.keySet()) {
            params.put(key.toLowerCase(), lstParam.get(key));
        }
        if (!this.phase.isJobUpdatable()) {
            if (params.containsKey(PARAM_PHASE)) {
                this.additionalParameters.put(PARAM_PHASE, (String)params.get(PARAM_PHASE));
            }
            return null;
        }
        if (params.containsKey(PARAM_OWNER)) {
            params.remove(PARAM_OWNER);
        }
        if (params.containsKey(PARAM_PARAMETERS)) {
            params.remove(PARAM_PARAMETERS);
        }
        if (params.containsKey(PARAM_RESULTS)) {
            params.remove(PARAM_RESULTS);
        }
        if (params.containsKey(PARAM_ERROR_SUMMARY)) {
            params.remove(PARAM_ERROR_SUMMARY);
        }
        if (params.containsKey(PARAM_QUOTE)) {
            params.remove(PARAM_QUOTE);
        }
        if (params.containsKey(PARAM_RUN_ID)) {
            this.setRunId((String)params.get(PARAM_RUN_ID));
            params.remove(PARAM_RUN_ID);
        }
        if (params.containsKey(PARAM_EXECUTION_DURATION)) {
            try {
                this.setExecutionDuration(Long.parseLong((String)params.get(PARAM_EXECUTION_DURATION)));
                params.remove(PARAM_EXECUTION_DURATION);
            }
            catch (NumberFormatException ex) {
                this.setExecutionDuration(0L);
                throw new UWSException("[Load default params] The parameter \"executionduration\" must be a long integer value.");
            }
        }
        if (params.containsKey(PARAM_DESTRUCTION_TIME)) {
            try {
                String time = params.get(PARAM_DESTRUCTION_TIME);
                if (time != null && !time.trim().isEmpty()) {
                    this.setDestructionTime(this.dateFormat.parse(time));
                }
                params.remove(PARAM_DESTRUCTION_TIME);
            }
            catch (ParseException e) {
                throw new UWSException("[Load default params] The destruction time format is incorrect.");
            }
        }
        return params;
    }

    protected boolean loadAdditionalParams() throws UWSException {
        return true;
    }

    protected synchronized void applyPhaseParam() throws UWSException {
        if (this.getAdditionalParameterValue(PARAM_PHASE) != null) {
            String newPhase = this.additionalParameters.get(PARAM_PHASE);
            if (newPhase.equalsIgnoreCase(PHASE_RUN)) {
                this.additionalParameters.remove(PARAM_PHASE);
                this.start();
            } else if (newPhase.equalsIgnoreCase(PHASE_ABORT)) {
                this.additionalParameters.remove(PARAM_PHASE);
                this.abort();
            }
        }
    }

    public final ExecutionPhase getPhase() {
        return this.phase.getPhase();
    }

    public final void setPhase(ExecutionPhase p) throws UWSException {
        this.setPhase(p, false);
    }

    public final void setPhase(ExecutionPhase p, boolean force) throws UWSException {
        ExecutionPhase oldPhase = this.phase.getPhase();
        this.phase.setPhase(p, force);
        if (this.phase.isFinished()) {
            this.executionManager.remove(this);
        }
        this.notifyObservers(oldPhase);
    }

    public final JobPhase getPhaseManager() {
        return this.phase;
    }

    public final void setPhaseManager(JobPhase jobPhase) {
        if (jobPhase != null) {
            this.phase = jobPhase;
        }
    }

    public final DateFormat getDateFormat() {
        return this.dateFormat;
    }

    public final void setDateFormat(DateFormat newDateFormat) {
        if (newDateFormat != null) {
            this.dateFormat = newDateFormat;
        }
    }

    public final Date getStartTime() {
        return this.startTime;
    }

    protected final void setStartTime(Date newDateTime) {
        this.startTime = newDateTime;
    }

    public final Date getEndTime() {
        return this.endTime;
    }

    protected final void setEndTime(Date newDateTime) {
        this.endTime = newDateTime;
        if (this.timExecDuration != null) {
            this.timExecDuration.cancel();
        }
    }

    public final long getExecutionDuration() {
        return this.executionDuration;
    }

    public final void setExecutionDuration(long executionDuration) {
        if (this.phase.isJobUpdatable()) {
            this.executionDuration = executionDuration < 0L ? 0L : executionDuration;
        }
    }

    public final Date getDestructionTime() {
        return this.destructionTime;
    }

    public final void setDestructionTime(Date destructionTime) {
        if (this.phase.isJobUpdatable() && (destructionTime == null || destructionTime.after(new Date()))) {
            this.destructionTime = destructionTime;
            if (this.myJobList != null) {
                this.myJobList.updateDestruction(this);
            }
        }
    }

    public final ErrorSummary getErrorSummary() {
        return this.errorSummary;
    }

    public final void setErrorSummary(ErrorSummary errorSummary) throws UWSException {
        if (this.isFinished()) {
            throw new UWSException(400, "[Set an error] Impossible to set an error summary after the job execution (now, phase = " + this.phase + ") !");
        }
        this.errorSummary = errorSummary;
    }

    public final String getJobId() {
        return this.jobId;
    }

    public final String getRunId() {
        return this.runId;
    }

    public final void setRunId(String name) {
        if (this.phase.isJobUpdatable()) {
            this.runId = name;
        }
    }

    public final String getOwner() {
        return this.owner;
    }

    public final long getQuote() {
        return this.quote;
    }

    public final void setQuote(long nbSeconds) {
        if (this.phase.isJobUpdatable()) {
            this.quote = nbSeconds;
        }
    }

    public final Set<String> getAdditionalParameters() {
        return this.additionalParameters.keySet();
    }

    public final int getNbAdditionalParameters() {
        return this.additionalParameters.size();
    }

    public final String getAdditionalParameterValue(String paramName) {
        return this.additionalParameters.get(paramName);
    }

    public final boolean addOrUpdateParameter(String paramName, String paramValue) throws UWSException {
        if (this.phase.isJobUpdatable()) {
            HashMap<String, String> param = new HashMap<String, String>();
            param.put(paramName, paramValue);
            return this.addOrUpdateParameters(param);
        }
        return false;
    }

    public boolean addOrUpdateParameters(Map<String, String> params) throws UWSException {
        boolean additionnalLoaded = false;
        Map<String, String> remaining = this.loadDefaultParams(params);
        if (remaining != null && this.phase.isJobUpdatable()) {
            this.additionalParameters.putAll(remaining);
            additionnalLoaded = this.loadAdditionalParams();
        }
        this.applyPhaseParam();
        return remaining == null || additionnalLoaded;
    }

    public final boolean removeAdditionalParameter(String paramName) {
        if (!this.phase.isJobUpdatable() || paramName == null) {
            return false;
        }
        return this.additionalParameters.remove(paramName.toLowerCase()) != null;
    }

    public final void removeAllAdditionalParameter() {
        if (this.phase.isJobUpdatable()) {
            this.additionalParameters.clear();
        }
    }

    public final Iterator<Result> getResults() {
        return this.results.iterator();
    }

    public final int getNbResults() {
        return this.results.size();
    }

    public boolean addResult(Result res) throws UWSException {
        if (res == null) {
            return false;
        }
        if (!this.isFinished()) {
            return this.results.add(res);
        }
        throw new UWSException(400, "[Add a result] Impossible to add a result after the job execution (now, phase = " + this.phase + ") !");
    }

    public final ExecutionManager getExecutionManager() {
        return this.executionManager;
    }

    public final void setExecutionManager(ExecutionManager newManager) throws UWSException {
        ExecutionManager oldManager = this.executionManager;
        this.executionManager = newManager;
        if (oldManager != null) {
            oldManager.remove(this);
        }
        if (this.executionManager != null) {
            this.executionManager.update(this);
        }
    }

    public final JobList<? extends AbstractJob> getJobList() {
        return this.myJobList;
    }

    public final void setJobList(JobList<? extends AbstractJob> jobList) throws UWSException {
        if (jobList != null && this.myJobList != null && jobList.equals(this.myJobList)) {
            return;
        }
        if (this.myJobList != null && this.myJobList.getJob(this.getJobId()) != null) {
            this.myJobList.removeJob(this.getJobId());
        }
        this.myJobList = jobList;
        try {
            if (this.myJobList != null && this.myJobList.getJob(this.getJobId()) == null) {
                this.myJobList.addNewJob(this);
            }
        }
        catch (UWSException ue) {
            this.myJobList = null;
            throw ue;
        }
    }

    public final long getTimeToWaitForEnd() {
        return this.waitForStop;
    }

    public final synchronized void setTimeToWaitForEnd(long timeToWait) {
        this.waitForStop = timeToWait;
    }

    public final synchronized void start() throws UWSException {
        this.start(this.executionManager != null);
    }

    public synchronized void start(boolean useManager) throws UWSException {
        if (this.isRunning()) {
            return;
        }
        if (useManager && this.executionManager != null) {
            this.executionManager.execute(this);
        } else {
            try {
                this.setPhase(ExecutionPhase.EXECUTING);
            }
            catch (UWSException ue) {
                if (this.isFinished()) {
                    throw new UWSException(400, "[Start a job] The job \"" + this.jobId + "\" has already been executed. It has finished with the phase \"" + (Object)((Object)this.getPhase()) + "\" !", ErrorType.TRANSIENT);
                }
                throw ue;
            }
            this.thread = new JobThread(this);
            this.thread.start();
            this.setStartTime(new Date());
            if (this.executionDuration != 0L && this.executionDuration > 0L) {
                this.timExecDuration = new Timer();
                this.timExecDuration.schedule((TimerTask)new DurationTimerTask(this), this.executionDuration * 1000L);
            }
        }
    }

    public final boolean isRunning() {
        return this.phase.isExecuting() && !this.isStopped();
    }

    public final boolean isFinished() {
        return this.phase.isFinished() && this.isStopped();
    }

    public synchronized void abort() throws UWSException {
        this.stop();
        if (this.isStopped()) {
            if (!this.phase.isFinished()) {
                this.setPhase(ExecutionPhase.ABORTED);
                this.setEndTime(new Date());
            } else if (this.thread == null || this.thread != null && !this.thread.isAlive()) {
                throw new UWSException(400, "[Abort a job] The job \"" + this.jobId + "\" has already been executed. It has finished with the phase \"" + (Object)((Object)this.getPhase()) + "\" !", ErrorType.TRANSIENT);
            }
        }
    }

    public synchronized void error(ErrorSummary error) throws UWSException {
        this.stop();
        if (this.isStopped()) {
            if (!this.phase.isFinished()) {
                this.setErrorSummary(error);
                this.setPhase(ExecutionPhase.ERROR);
                this.setEndTime(new Date());
            } else if (this.thread != null && !this.thread.isAlive()) {
                throw new UWSException(400, "[Stop a job with error] The job \"" + this.jobId + "\" has already been executed. It has finished with the phase \"" + (Object)((Object)this.getPhase()) + "\" !", ErrorType.TRANSIENT);
            }
        }
    }

    public synchronized void error(UWSException ue) throws UWSException {
        boolean published = UWSToolBox.publishErrorSummary(this, ue.getCause() != null ? ue.getCause().getMessage() : ue.getMessage(), ue.getUWSErrorType());
        if (!published) {
            throw new UWSException("[Set an error] Impossible to set the given UWS exception to the job " + this.jobId + " !");
        }
    }

    protected synchronized void stop() {
        if (!this.isStopped()) {
            this.thread.interrupt();
            if (this.waitForStop > 0L) {
                try {
                    this.thread.join(this.waitForStop);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }

    protected final synchronized boolean isStopped() {
        return this.thread == null || !this.thread.isAlive() || this.thread.isInterrupted() || this.thread.isFinished();
    }

    protected abstract void jobWork() throws UWSException, InterruptedException;

    public void clearResources() {
        if (this.isRunning()) {
            try {
                this.abort();
            }
            catch (UWSException e) {
                this.stop();
            }
        }
        try {
            if (this.executionManager != null) {
                this.executionManager.remove(this);
            }
        }
        catch (UWSException ue) {
            System.err.println("### [Clear Resources] ERROR While clearing resources of " + this.jobId + ": ###");
            ue.printStackTrace();
        }
        if (this.timExecDuration != null) {
            this.timExecDuration.cancel();
        }
        this.thread = null;
    }

    protected void finalize() throws Throwable {
        try {
            this.clearResources();
        }
        finally {
            super.finalize();
        }
    }

    public final boolean addObserver(JobObserver observer) {
        if (observer != null && !this.observers.contains(observer)) {
            this.observers.add(observer);
            return true;
        }
        return false;
    }

    public final int getNbObservers() {
        return this.observers.size();
    }

    public final Iterator<JobObserver> getObservers() {
        return this.observers.iterator();
    }

    public final boolean removeObserver(JobObserver observer) {
        return this.observers.remove(observer);
    }

    public final void removeAllObservers() {
        this.observers.clear();
    }

    public final void notifyObservers(ExecutionPhase oldPhase) throws UWSException {
        int i = 0;
        Object observer = null;
        String errors = null;
        while (i < this.observers.size()) {
            if (i == 0 && observer == null) {
                observer = this.observers.get(i);
            } else if (observer.equals(this.observers.get(i))) {
                if (++i < this.observers.size()) {
                    observer = this.observers.get(i);
                } else {
                    return;
                }
            }
            try {
                observer.update(this, oldPhase, this.getPhase());
            }
            catch (UWSException ex) {
                errors = errors == null ? "\t* " + ex.getMessage() : String.valueOf(errors) + "\n\t* " + ex.getMessage();
            }
        }
        if (errors != null) {
            throw new UWSException(500, "[Notify job observers] Some observers of \"" + this.jobId + "\" can not have been updated:\n" + errors);
        }
    }

    public final UWSException getWorkError() {
        return this.thread == null && !this.thread.isAlive() ? null : this.thread.getError();
    }

    @Override
    public String serialize(UWSSerializer serializer, String ownerId) throws UWSException {
        return serializer.getJob(this, true);
    }

    public String serialize(String[] attributes, UWSSerializer serializer) throws UWSException {
        return serializer.getJob(this, attributes, true);
    }

    public void serialize(OutputStream output, String[] attributes, UWSSerializer serializer) throws UWSException {
        String attributeName = null;
        attributeName = attributes == null || attributes.length <= 0 ? "the job " + this.toString() : "the given attribute \"" + attributeName + "\" of {" + this.toString() + "}";
        if (output == null) {
            throw new UWSException(500, "[Serialize] Impossible to serialize " + attributeName + " because the given stream is null !");
        }
        try {
            String serialization = this.serialize(attributes, serializer);
            if (serialization == null) {
                throw new UWSException(500, "[Serialize] Impossible to write the serialization of " + attributeName + " because it is NULL !");
            }
            output.write(serialization.getBytes());
        }
        catch (IOException ex) {
            throw new UWSException(500, (Throwable)ex, "[Serialize] Impossible to serialize " + attributeName + " !");
        }
    }

    public String toString() {
        return "JOB {jobId: " + this.jobId + "; phase: " + this.phase + "; runId: " + this.runId + "; ownerId: " + this.owner + "; executionDuration: " + this.executionDuration + "; destructionTime: " + this.destructionTime + "; quote: " + this.quote + "; NbResults: " + this.results.size() + "; " + (this.errorSummary != null ? this.errorSummary.toString() : "No error") + " }";
    }

    public boolean equals(Object anotherJob) {
        if (anotherJob instanceof AbstractJob) {
            return this.jobId.equals(((AbstractJob)anotherJob).jobId);
        }
        return super.equals(anotherJob);
    }

    @Deprecated
    public final Set<String> getOtherParameters() {
        return this.getAdditionalParameters();
    }

    @Deprecated
    public final int getNbOtherParameters() {
        return this.getNbAdditionalParameters();
    }

    @Deprecated
    public final String getOtherParameterValue(String paramName) {
        return this.getAdditionalParameterValue(paramName);
    }

    @Deprecated
    public final boolean removeOtherParameter(String paramName) {
        return this.removeAdditionalParameter(paramName);
    }

    @Deprecated
    public final void removeAllOtherParameter() {
        this.removeAllAdditionalParameter();
    }

    @Deprecated
    protected final void checkPhaseParam() throws UWSException {
        this.applyPhaseParam();
    }

    @Deprecated
    protected final boolean publishExecutionError(UWSException ue) throws UWSException {
        try {
            this.error(ue);
            return true;
        }
        catch (UWSException ex) {
            return false;
        }
    }

    protected static class DurationTimerTask
    extends TimerTask {
        private static final long serialVersionUID = 1L;
        protected final AbstractJob job;

        public DurationTimerTask(AbstractJob j) {
            this.job = j;
        }

        @Override
        public void run() {
            try {
                this.job.abort();
            }
            catch (UWSException e) {
                e.printStackTrace();
            }
        }
    }
}

