/*
 * Decompiled with CFR 0.152.
 */
package uws;

import uws.job.ErrorType;

public class UWSException
extends Exception {
    private static final long serialVersionUID = 1L;
    public static final int NO_CONTENT = 204;
    public static final int SEE_OTHER = 303;
    public static final int BAD_REQUEST = 400;
    public static final int FORBIDDEN = 403;
    public static final int NOT_FOUND = 404;
    public static final int INTERNAL_SERVER_ERROR = 500;
    public static final int NOT_IMPLEMENTED = 501;
    public static final int SERVICE_UNAVAILABLE = 503;
    public static final int USER_ACCESS_DENIED = 530;
    protected int httpErrorCode = 404;
    protected ErrorType errorType = ErrorType.FATAL;

    public UWSException(String msg) {
        this(msg, ErrorType.FATAL);
    }

    public UWSException(String msg, ErrorType type) {
        super(msg);
        if (type != null) {
            this.errorType = type;
        }
    }

    public UWSException(Throwable t) {
        this(t, ErrorType.FATAL);
    }

    public UWSException(Throwable t, ErrorType type) {
        super(t);
        if (type != null) {
            this.errorType = type;
        }
    }

    public UWSException(int httpError, String msg) {
        this(msg);
        if (httpError >= 0) {
            this.httpErrorCode = httpError;
        }
    }

    public UWSException(int httpError, String msg, ErrorType type) {
        this(msg, type);
        if (httpError >= 0) {
            this.httpErrorCode = httpError;
        }
    }

    public UWSException(int httpError, Throwable t) {
        this(t);
        if (httpError >= 0) {
            this.httpErrorCode = httpError;
        }
    }

    public UWSException(int httpError, Throwable t, ErrorType type) {
        this(t, type);
        if (httpError >= 0) {
            this.httpErrorCode = httpError;
        }
    }

    public UWSException(int httpError, Throwable t, String msg) {
        this(httpError, t, msg, ErrorType.FATAL);
    }

    public UWSException(int httpError, Throwable t, String msg, ErrorType type) {
        super(msg, t);
        if (httpError >= 0) {
            this.httpErrorCode = httpError;
        }
        if (type != null) {
            this.errorType = type;
        }
    }

    public int getHttpErrorCode() {
        return this.httpErrorCode;
    }

    public ErrorType getUWSErrorType() {
        return this.errorType;
    }
}

